using System;
using Server.ContextMenus;
using System.Collections.Generic;

namespace Server.Items
{
    public class CrusadersWarMace : LevelWarMace
    {
        private int m_Bonus = 0;
        private int m_KoBonus = 0;
        private bool m_Activated = false;

        //     		[CommandProperty(AccessLevel.GameMaster)]
        public int Bonus { get { return m_Bonus; } set { m_Bonus = Math.Min(value, 10); InvalidateProperties(); } }

        [CommandProperty(AccessLevel.GameMaster)]
        public int KoBonus { get { return m_KoBonus; } set { m_KoBonus = value; InvalidateProperties(); } }

        [CommandProperty(AccessLevel.GameMaster)]
        public bool Activated { get { return m_Activated; } set { m_Activated = value; InvalidateProperties(); } }

        public bool UpgradeTier()
        {
            if (m_Bonus + 1 > 10) //max tier
                return false;

            m_Bonus++;

            this.SkillBonuses.Skill_1_Value += 1.0;
            this.SkillBonuses.Skill_2_Value += 1.0;
            this.Attributes.WeaponDamage += 2;
            this.Attributes.AttackChance += 2;
            this.Attributes.Luck += 5;
            this.Attributes.ReflectPhysical += 2;
            this.Attributes.BonusStr += 1;
            this.WeaponAttributes.LowerStatReq = (m_Bonus * 10);

            return true;
        }

        public bool UpgradeKoTier()
        {
            if (m_KoBonus + 1 > 25 || !m_Activated) //max tier
                return false;

            m_KoBonus++;
            return true;
        }

        public override int AosMinDamage { get { return 16; } }
        public override int AosMaxDamage { get { return 17; } }
        public override int AosSpeed { get { return 30; } }

        public override int ArtifactRarity { get { return 70; } }
        public override int InitMinHits { get { return 125; } }
        public override int InitMaxHits { get { return 125; } }

        [Constructable]
        public CrusadersWarMace()
        {
            Weight = 10.0;
            this.Hue = 2638;
            this.Name = "<bodytext=#DA70D6><center>Crusader's War Mace";
            Slayer = SlayerName.Silver;
            Slayer2 = SlayerName.Exorcism;

            SkillBonuses.SetValues(0, SkillName.Tactics, 10.0);
            SkillBonuses.SetValues(1, SkillName.Healing, 10.0);

            Attributes.WeaponDamage = 50;
            Attributes.AttackChance = 10;
            Attributes.DefendChance = 20;
            Attributes.WeaponSpeed = 25;
            Attributes.BonusStr = 5;
            Attributes.Luck = 200;
            WeaponAttributes.SelfRepair = 10;
            WeaponAttributes.HitLeechHits = 20;
            WeaponAttributes.HitLeechMana = 20;
            WeaponAttributes.HitLeechStam = 20;
            WeaponAttributes.HitHarm = 20;
            WeaponAttributes.HitLightning = 20;
            WeaponAttributes.LowerStatReq = 10;
            // 			WeaponAttributes.UseBestSkill = 1;
        }

        public override void GetProperties(ObjectPropertyList list)
        {
            base.GetProperties(list);

            if (this.Hue == 2638)
            {
                list.Add(1072378);
                list.Add(CrusadersShield.PropsString + (!m_Activated ? "<basefont color=White>" : "\nElite Slayer:<basefont color=White> +" + (m_Activated ? m_KoBonus.ToString() + "%" : "XXX")));
            }
        }

        public override void AddNameProperties(ObjectPropertyList list)
        {
            base.AddNameProperties(list);

            // 			if ( m_Bonus > 0 )
            list.Add(1072819, "<basefont color=#9999FF>" + String.Format("{0} [{1}]", m_Bonus, m_Activated ? m_KoBonus.ToString() : "XXX") + "<basefont color=White>");//Current Tier: ~1_TIER~

            list.Add(1072376, "2");

            if (this.Parent is Mobile)
            {
                if (this.Hue == 2628)
                {
                    list.Add(1072377);
                    list.Add(CrusadersShield.PropsString + (!m_Activated ? "<basefont color=White>" : "\nElite Slayer:<basefont color=White> +" + (m_Activated ? m_KoBonus.ToString() + "%" : "XXX")));
                }
            }
        }

        public override void GetContextMenuEntries(Mobile from, List<ContextMenuEntry> list)
        {
            if (IsChildOf(from.Backpack) && !m_Activated) // Make sure its in their pack
            {
                list.Add(new CrusadersShield.ActivateEntry(this, from));
            }

            base.GetContextMenuEntries(from, list);
        }

        public override bool OnEquip(Mobile from)
        {

            BaseShield shield = from.FindItemOnLayer(Layer.TwoHanded) as BaseShield;

            if (shield != null && shield is CrusadersShield)
            {
                Effects.PlaySound(from.Location, from.Map, 503);
                from.FixedParticles(0x376A, 9, 32, 5030, EffectLayer.Waist);

                Hue = 2628;
                shield.Hue = 2628;
                shield.InvalidateProperties();
            }

            this.InvalidateProperties();

            return base.OnEquip(from);
        }

        public override void OnRemoved(object parent)
        {
            if (parent is Mobile)
            {
                Mobile m = (Mobile)parent;
                Hue = 2638;
                m.FixedParticles(0x3779, 10, 15, 5009, EffectLayer.Waist);
                Effects.PlaySound(m.Location, m.Map, 0x1E6);

                if (m.FindItemOnLayer(Layer.TwoHanded) is CrusadersShield)
                {
                    BaseShield shield = m.FindItemOnLayer(Layer.TwoHanded) as BaseShield;
                    shield.Hue = 2638;
                    shield.InvalidateProperties();
                }

                CrusadersShield.UnsummonAngel(m);
                this.InvalidateProperties();
            }
            base.OnRemoved(parent);
        }

        public override void GetDamageTypes(Mobile wielder, out int phys, out int fire, out int cold, out int pois, out int nrgy)
        {
            pois = fire = cold = 0;
            phys = nrgy = 50;
        }

        public CrusadersWarMace(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write(2);
            // version 2
            writer.Write(m_KoBonus);
            writer.Write(m_Activated);
            // version 1
            writer.Write(m_Bonus);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);
            int version = reader.ReadInt();

            switch (version)
            {
                case 2:
                    {
                        m_KoBonus = reader.ReadInt();
                        m_Activated = reader.ReadBool();
                        goto case 1;
                    }
                case 1:
                    {
                        m_Bonus = reader.ReadInt();
                        break;
                    }
            }
        }
    }
}